program InneTypy;

uses
  RTTI, System.SysUtils, TypInfo;

type
  TRekordDemo = record
    Jeden, Dwa, Trzy: Integer;
    procedure Proc1;
    procedure Proc2;
    procedure Proc3;
  end;

procedure TRekordDemo.Proc1;
begin
end;

procedure TRekordDemo.Proc2;
begin
end;

procedure TRekordDemo.Proc3;
begin
end;

type
  TTrójwymiarowaTabelaTekstowa = array[0..2, 0..3, 0..4] of String;

var
  Kontekst: TRttiContext;
  TypTymcz: TRttiType;
  TypPorzTymcz: TRTTIOrdinalType;
  RekordTymcz: TRttiRecordType;
  PoleTymcz: TRttiField;
  MetodaTymcz: TRttiMethod;
  TabelaTymcz: TRttiArrayType;
begin
  // Typ porządkowy
  TypTymcz := Kontekst.GetType(TypeInfo(Byte));
  if TypTymcz.IsOrdinal then
  begin
    TypPorzTymcz := TypTymcz as TRTTIOrdinalType;
    WriteLn('Minimalna wartość dla typu ', TypPorzTymcz.Name, ' wynosi: ', TypPorzTymcz.MinValue);
    WriteLn('Maksymalna wartość dla typu ', TypPorzTymcz.Name, ' wynosi: ', TypPorzTymcz.MaxValue);
  end;

  // Rekord
  TypTymcz := Kontekst.GetType(TypeInfo(TRekordDemo));
  if TypTymcz.IsRecord then
  begin
    RekordTymcz := TypTymcz.AsRecord;
    WriteLn(RekordTymcz.Name, ' zawiera nastepujące metody: ');
    for MetodaTymcz in RekordTymcz.GetMethods do
    begin
      WriteLn(' ', MetodaTymcz.Name);
    end;
    WriteLn('... i pola:');
    for PoleTymcz in RekordTymcz.GetFields do
    begin
      WriteLn(' ', PoleTymcz.Name);
    end;
    WriteLn;
  end;

  // Tabele
  TypTymcz := Kontekst.GetType(TypeInfo(TTrójwymiarowaTabelaTekstowa));
  if TypTymcz.TypeKind = tkArray then
  begin
    TabelaTymcz := TypTymcz as TRttiArrayType;
    WriteLn(TabelaTymcz.Name, ' jest to ', TabelaTymcz.DimensionCount,
      '-wymiarowa tabela zawierająca ', TabelaTymcz.TotalElementCount,
      ' elementów typu ', TabelaTymcz.ElementType.Name);
  end;

  ReadLn;
end.
